% A 2.6: Impuls- und Sprungantwort im eines einfachen Systems 1.Ordnung
% bung Signalverarbeitung, 19.04.2011

clear all % leeren des workspace
close all % alle plots schlieen
clc % leeren des comand window

f0   = 0.5;   % Abtastfrequenz [Hz]

T0   = 1/f0; % Abtastzeit [s]
tmax = 100;  % Endzeit [s]
kmin = 0; % erster Abtastpunkt
kmax = floor(tmax / T0); % letzter Abtastpunkt


% Definition der Eingangsgre
impuls = [1/T0 zeros(1,kmax)];   % Einheitsimpuls
sprung = ones(1,kmax+1);         % Einheitssprung

u = sprung; % wahl des Eingangssignals

% Parameter der Differenzengleichung: y(k) = b0*u(k) - a0*y(k-1)
a1 = -0.9;
b0 = 0.2;

% Anfangswerte
y(1) = b0*u(1);
y(2) = b0*u(2)-a1*y(1);

% Rekursive Berechnung
for k = kmin+2:kmax+1
   y(k) = b0*u(k)-a1*y(k-1); % Antwort des Systems erster Ordnung
end

%%%%%%%%%%%%%%%
% Darstellung %
%%%%%%%%%%%%%%%

figure(1)
k = kmin:kmax; % Diskreter Zeitvektor k = t/T0
% diskretes Signal darstellen
plot(k*T0,y,'r-o','linewidth',1.5,'markersize',5)
set(gca,'fontsize',13)
xlabel('Zeit t [sec]','fontsize',13)
ylabel('Systemantwort','fontsize',13)




